﻿/*
  popup.js
  fffadedev
  08/24/25

  Manages the interface for a popup message
 */


class Popup
{
  constructor() {
    this.el = document.getElementById('popup');
    this.overlayElement = document.getElementById('popup-overlay');
    this.buttons = new PopupButtons();
    this.buttons.hide();
    this.buttons.onCloseClick = this.hide.bind(this);
    this.textElement = document.getElementById('popup-text');

    this.overlayElement.style.display = 'none';
    this.overlayElement.style.opacity = '0';

    // Force child element click to not trigger overlay
    this.el.onclick = (e) => { e.stopPropagation(); };
    // Overlay click hides the popup
    this.overlayElement.onclick = this.hide.bind(this);
  }

  hide() {

    // Trigger the fade-out animation through CSS and remove the CSS class after completion
    this.overlayElement.style.opacity = '0';

    setTimeout(() => {
      this.overlayElement.style.display = 'none';
      this.buttons.hide();
    }, 1000);
  }

  showTimed(text, hasButtons = false, ms) {
    return new Promise(resolve => {
      this.show(text, hasButtons);
      setTimeout((() => {
        this.hide();
        resolve();
      }).bind(this), ms);
    });
  }

  show(text, hasButtons = false) {

    this.overlayElement.style.display = 'flex';
    this.overlayElement.offsetHeight;
    this.overlayElement.style.opacity = '1';

    if(hasButtons)
      this.buttons.show();

    this.textElement.innerHTML = text;
  }
}
