﻿/*
  popup_buttons.js
  fffadedev
  08/27/25

  Manages the control interface within a popup
 */


class PopupButtons
{
  constructor() {
    this.el = document.getElementById('popup-buttons');
    this.replayButton = document.getElementById('replay');
    this.closeButton = document.getElementById('close');
    this.replayButton.onclick = (() => {
      if(this.onReplayClick !== null)
        this.onReplayClick();
      else
        console.warn("Replay button clicked. Warning: This function has not been implemented.");
    }).bind(this);
    this.closeButton.onclick = (() => {
      if(this.onCloseClick !== null)
        this.onCloseClick();
      else
        console.log("Close button clicked. Warning: This function has not been implemented.");
    }).bind(this);
  }

  hide() {
    this.el.style.display = 'none';
  }

  show() {
    this.el.style.display = 'flex';
  }
}
