﻿/*
  sidebar.js
  fffadedev
  08/24/25

  Manages the interface of the sidebar that displays specific game details
 */


class Sidebar
{
  constructor() {
    this.el = document.getElementById('sidebar');
    this.timerEl = document.getElementById('timer');
    this.scoreEl = document.getElementById('score');
    this.highscoreEl = document.getElementById('highscore');
    this.playButtonEl = document.getElementById('play');
    this.clearHighscoreButtonEl = document.getElementById('clear-highscore');
  }

  updateTimer(seconds) {

    const minutes = Math.floor(seconds / 60);
    seconds = seconds % 60;

    this.timerEl.innerHTML = `${minutes}:${(seconds < 10 ? '0' : '') + seconds}`;
  }

  updateScore(points) {
    this.scoreEl.innerHTML = points.toString();
  }

  updateHighscore(points) {
    this.highscoreEl.innerHTML = points.toString();
  }

  hidePlayButton() {
    this.playButtonEl.style.display = 'none';
  }

  showPlayButton(fn) {
    this.playButtonEl.style.display = 'flex';
    this.playButtonEl.onclick = fn;
  }

  hideClearHighscoreButton() {
    this.clearHighscoreButtonEl.style.display = 'none';
  }

  showClearHighscoreButton(fn) {
    this.clearHighscoreButtonEl.style.display = 'flex';
    this.clearHighscoreButtonEl.onclick = fn;
  }
}
