﻿/* Reading system files */
let Wordles = [];
let ValidWords = [];

function loadWordles()
{
  return new Promise((resolve, reject) => {

    try {
      const filePath = "./res/wordle-list.txt";
      fetch(filePath).then((res => {
        if (!res.ok) {
          reject(res.status);
          throw new Error(`HTTP error! status: ${res.status}`);
        }
        res.text().then((text) => {

          Wordles = eval(text);
          console.log("Successfully loaded list of " + Wordles.length + " wordle words.");

          // Read valid words as well
          const path = "./res/valid-wordle-words.txt";

          fetch(path).then((res => {
            if (!res.ok) {
              reject(res.status);
            }
            res.text().then((text) => {
              ValidWords = text.split("\n");
              console.log("Successfully loaded list of " + ValidWords.length + " valid words.");

              resolve();
            })
          }));
        })
      }));

    } catch (error) {
      console.error("Error reading file:", error);
      reject(error);
    }
  });
}



